### Overview

- **Flexibility**: Current networks support information sharing and collaboration.
- **Risks**: Unmonitored traffic can lead to data leaks and malware transmission.

### Example Scenarios

- File sharing can leak sensitive information.
- Malware often spreads through file downloads.

## Cisco Secure Firewall Threat Defense

### File Detection and Action

- **File Type Detection**: Detect or block files based on type.
    - Example: Block all PDFs leaving the enterprise.
- **Malware Protection**: Detects or blocks malware during file transfers.
    - Relies on Advanced Malware Protection (AMP) technology.

### Malware Detection

- **Network-based Detection**: Monitors file types for malware over protocols.
- Actions: Alert or block malware transmission.

## Malware and File Policy Rules

### Configuration

- **Association with Access Control Policy (ACP)**:
    - ACP rules determine traffic sent to malware and file policy.
- **Policy Roles**:
    - Decide which files and protocols to inspect.
    - Determine transfer direction and action (detect/block).

### File Dispositions

- **Process**: Cisco CSI Cloud assigns dispositions to files.
    - **Dispositions**:
        - **Malware**: Categorized as malware.
        - **Clean**: Categorized as clean.
        - **Unknown**: Unassigned disposition.
        - **Unavailable**: System cannot query AMP Cloud.

### AMP Operation

- **Architecture**:
    - SHA-256 values checked against AMP Cloud database.
    - Provides real-time threat detection updates.
- **Process**:
    - Threat defense calculates SHA-256.
    - Queries management center and AMP Cloud for disposition.
    - Actions based on disposition.

## Additional Detection Engines

### File Inspection Methods

- **AMP Cloud Lookup**: Queries AMP cloud for SHA-256-based disposition.
- **Spero Analysis**: Examines file metadata and headers.
- **Local Malware Analysis**: Inspects files locally using Talos-provided rules.
- **Dynamic Analysis**: Submits files to Cisco Secure Malware Analytics for sandbox analysis.

## Creating Malware and File Policy Rule

### Rule Configuration

- **Rule Actions**:
    - Block files based on type or disposition.
    - Detect files to log type detection.
    - Cloud lookup for malware disposition.
- **Protocol Support**:
    - Detect files in FTP, HTTP, SMTP, IMAP, POP3, NetBIOS-ssn (SMB).

### File Types and Actions

- **Categories**: Multimedia, executables, PDFs, etc.
- **Actions**: Block, detect, analyze, store files.

## Assigning Malware and File Policy in ACP

### Process

- **Assignment**: Assign malware and file policy to ACP rule with Allow or Interactive Block actions.
- **Customization**: Tune traffic to match specific malware and file policies.

## Malware and File Events

### Event Logging

- **File Events**: Logs file type and malware detection.
- **Malware Events**: Logs detailed AMP-related information.

### Management Center GUI

- **Menus**:
    - File events show type and malware detection results.
    - Malware events show detailed malicious file transfer data.